//=============================================================================
// Rocket.
//=============================================================================
class MSCFireworkRocket extends DeusExProjectile;

var float mpBlastRadius;

var ParticleGenerator fireGen;
var ParticleGenerator smokeGen;

//NEW CRAP FOR OVERKILL TECHNOLOGY
//Did I say overkill... I meant CELEBRATION technology

var int PayFlow, PayloadLeft;
var bool bReleasePayload;
var float ReleaseTime, FlowTime;


function PostBeginPlay()
{
	Super.PostBeginPlay();

   if (Level.NetMode == NM_DedicatedServer)
      return;
   
   SpawnRocketEffects();
}

simulated function PostNetBeginPlay()
{
   Super.PostNetBeginPlay();
   
   if (Role != ROLE_Authority)
      SpawnRocketEffects();
}

function Texture RandFireworkColor()
{
 local int R;
 
 R = Rand(4);
 
 if (R == 0) return Texture'RawRed';
 if (R == 1) return Texture'RawPurple';
 if (R == 2) return Texture'RawBlue';
 if (R == 3) return Texture'RawGreen';
}

simulated function SpawnRocketEffects()
{
	Multiskins[0] = RandFireworkColor(); 

	fireGen = Spawn(class'ParticleGenerator', Self);
	if (fireGen != None)
	{
      fireGen.RemoteRole = ROLE_None;
		fireGen.particleTexture = Texture'Effects.Fire.Fireball1';
		fireGen.particleDrawScale = 0.1;
		fireGen.checkTime = 0.01;
		fireGen.riseRate = 0.0;
		fireGen.ejectSpeed = 0.0;
		fireGen.particleLifeSpan = 0.1;
		fireGen.bRandomEject = True;
		fireGen.SetBase(Self);
	}
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
      smokeGen.RemoteRole = ROLE_None;
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.3;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();
	if (fireGen != None)
		fireGen.DelayedDestroy();

	Super.Destroyed();
}

function Rotator GetPayloadRot(out Rotator Rot2)
{
 local Rotator Rot1;
 local int i;
 
 i = Rand(4) + 1;
 
 if (i == 1)
 {
  Rot1 = Rotation + rot(0,16384,9362);
  Rot2 = Rotation + rot(0,-16384,-9362);
 }
 if (i == 2)
 {
  Rot1 = Rotation + rot(0,16384,0);
  Rot2 = Rotation + rot(0,-16384,0);
 } 
 if (i == 3)
 {
  Rot1 = Rotation + rot(0,16384,18724);
  Rot2 = Rotation + rot(0,-16384,-18724);
 } 
 if (i == 4)
 {
  Rot1 = Rotation + rot(0,-16384,-9362);
  Rot2 = Rotation + rot(0,16384,9362);
 } 
 
 return Rot1;
}

function ReleasePayload()
{
 local MSCClusterPopit LS1, LS2;
 local rotator TempRot, TempRot2;
 
 TempRot = GetPayloadRot(TempRot2);
 
 LS1 = spawn(class'MSCClusterPopit', Owner,, Location + (vect(0, 2.5, 0) >> Rotation), TempRot);
 LS2 = spawn(class'MSCClusterPopit', Owner,, Location - (vect(0, 2.5, 0) >> Rotation), TempRot2);
}

function Tick(float D)
{
 local int i;
 
 Super.Tick(D);
 
 ReleaseTime += D;
 
 if (ReleaseTime > 0.375 && PayFlow <= 0)
 {
  PayloadLeft = 20;
  bReleasePayload = True;
 }
 
 if (bReleasePayload)
 {
  FlowTime += D;
  
  if (FlowTime > 0.35 && PayFlow < 5)
  {
   PayFlow++;
  }
  if (FlowTime > 0.35)
  {
   FlowTime = 0.000000;

   for(i=0; i<PayFlow; i++)
   {
    if (PayloadLeft > 0)
    {
     ReleasePayload();
    }
    PayloadLeft--;
   }
  }
 }
 
}

simulated function Timer()
{
   if (Level.NetMode != NM_Standalone)
   {   
      Explode(Location, vect(0,0,1));
   }
}


simulated singular function ZoneChange( ZoneInfo NewZone )
{
	local float splashsize;
	local actor splash;

	if ( NewZone.bWaterZone )
	{
		Velocity = 0.6 * Velocity;
			splashSize = 0.0005 * (250 - 0.5 * Velocity.Z);
			if ( Level.NetMode != NM_DedicatedServer )
			{
				if ( NewZone.EntrySound != None )
					PlaySound(NewZone.EntrySound, SLOT_None, splashSize);
				if ( NewZone.EntryActor != None )
				{
					splash = Spawn(NewZone.EntryActor); 
					if ( splash != None )
						splash.DrawScale = 4 * splashSize;
				}
			}

		if (smokeGen != None)
			smokeGen.DelayedDestroy();
	}
}

defaultproperties
{
     mpBlastRadius=768.000000
     bExplodes=True
     bBlood=True
     bDebris=False
     DrawScale=1.000000
     blastRadius=192.000000
     DamageType=exploded
     AccurateRange=14400
     maxRange=24000
     bTracking=True
     ItemName="Tylerstanian Super Firework Missle"
     ItemArticle="a"
     speed=6667.000000
     MaxSpeed=1000.000000
     Damage=5000.000000
     MomentumTransfer=10000
     SpawnSound=Sound'DeusExSounds.Weapons.GEPGunFire'
     ImpactSound=Sound'DeusExSounds.Generic.SmallExplosion1'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Mesh=LodMesh'FireworkRocket'
     SoundRadius=16
     SoundVolume=224
     AmbientSound=Sound'Flare'
     RotationRate=(Pitch=32768,Yaw=32768)
     bIgnoresNanoDefense=True
}
